#ifdef GL_ES
    precision mediump float;
#endif

varying vec4 v_color;
varying vec2 v_texCoords;
uniform sampler2D u_texture;
uniform float u_time; // Time uniform to drive color transition

void main() {
    // Base texture color
    vec4 baseColor = texture2D(u_texture, v_texCoords) * v_color;
    
    // Vignette effect
    float vignette = 1.0 - dot(v_texCoords - 0.5, v_texCoords - 0.5) * 0.65;
    vignette = clamp(vignette, 0.3, 1.0);
   
    // Linear reflected gradient with color transition
    vec3 redColor = vec3(1.0, 0.0, 0.0); // Red
    vec3 blueColor = vec3(0.0, 0.0, 1.0); // Blue
    float transitionPeriod = 20.0; // 20 seconds for full cycle
    float t = sin(u_time * 3.14159 / transitionPeriod); // Smooth oscillation
    t = (t + 1.0) * 0.5; // Remap to [0,1]
    vec3 gradientColor = mix(redColor, blueColor, t); // Interpolate between red and blue
    
    // Linear reflected gradient (mirrored horizontally)
    float gradient = abs(v_texCoords.x - 0.5) * 2.0; // Reflected gradient (0 at center, 1 at edges)
    float gradientStrength = 0.50; // Adjust intensity
    vec3 gradientEffect = gradientColor * gradient * gradientStrength;
    
    // Combine effects
    vec4 finalColor = baseColor;
    finalColor.rgb *= vignette;
    finalColor.rgb += gradientEffect; // Additive gradient
    finalColor.a = 1.0;

    gl_FragColor = finalColor;
}